# Change log for the Mod9 ASR C++ Library

## [1.1.0] - Mar 18, 2022

### Added

- `Connection::abort()`, which will abort the connection. Pending
and future reads and write will throw an exception.

- `Connection::is_aborted()`, which returns `true` if the connection
was aborted.

- Example code in `mod9-asr-example.cc` to demonstrate `abort()`.

## [1.0.0] - Feb 18, 2022

This version has undergone extensive stress testing, static analysis,
and dynamic analysis, but differs only inconsequentially from 0.3.0.

## [0.3.0] - Feb 4, 2022

### Fixed

- Removed call to the system function `gethostbyname()` which is not
thread safe. Replaced with call to `getaddrinfo()`, which is thread
safe.

### Changed

- The `port` is now always specified as a string rather than as an
integer. This is required by `getaddrinfo()`, and allows the use of
named ports (e.g. as specified in `/etc/services`) in addition to
integers.

- The `main()` in `example/mod9-asr-example.cc` now is wrapped with
a `try/catch` block. This allows easier testing with `valgrind` but
also prevents core dumps on unexpected exceptions.

### Added

- IPv6 support.
